<?php
/*
 * @copyright Copyright (c) 2021 AltumCode (https://altumcode.com/)
 *
 * This software is exclusively sold through https://altumcode.com/ by the AltumCode author.
 * Downloading this product from any other sources and running it without a proper license is illegal,
 *  except the official ones linked from https://altumcode.com/.
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose Language',
    'global.theme_style' => 'Switch to %s Mode',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available..',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.export' => 'Export',
    'global.export_csv' => 'Export to CSV',
    'global.export_json' => 'Export to JSON',
    'global.export_pdf' => 'Export to PDF',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',

    'global.info_message.confirm_delete' => 'Are you sure you want to delete this?',
    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is limited. Please get a new plan!',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the fields!',
    'global.error_message.empty_field' => 'This field is required, you must fill it!',
    'global.error_message.invalid_captcha' => 'The captcha code is not valid!',
    'global.error_message.invalid_file_type' => 'Invalid file type!',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again!',
    'global.error_message.basic' => 'We could not perform your requested command!',
    'global.error_message.file_size_limit' => 'Your uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'Your password must be between 6 and 64 characters!',
    'global.error_message.passwords_not_matching' => 'Your entered passwords do not match!',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website Logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha Field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.status' => 'Status',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.all' => 'All',
    'global.filters.results_per_page' => 'Results per page',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.last_7_days' => 'Last 7 days',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s until',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',

    'global.emails.user_activation.subject' => 'Confirm your new account - {{WEBSITE_TITLE}}',
    'global.emails.user_activation.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and you are ready,<br /><br />you just need to click the following link in order to join {{WEBSITE_TITLE}}<br /><br /><a href="{{ACTIVATION_LINK}}">Activate your account</a><br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}">Confirm email address change</a><br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is your reset password link: <a href="{{LOST_PASSWORD_LINK}}">Reset Password</a><br /><br />If you did not request this, you can ignore it!<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />Your account plan is now paid until {{PLAN_EXPIRATION_DATE}}!<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your {{PLAN_NAME}} plan is going to expire in {{DAYS_UNTIL_EXPIRATION}} days.<br /><br />Please <a href="{{USER_PLAN_RENEW_LINK}}">renew your plan</a> if you wish to continue using our website with all the features you have.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply <a href="{{LOGIN_LINK}}">login</a> with your account and the deletion process will be stopped.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to <a href="{{REGISTER_LINK}}">register</a> another account with us.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM_NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hey there,<br /><br />You have been invited by <strong>{{USER_NAME}}</strong> ({{USER_EMAIL}}) to join the <strong>{{TEAM_NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}">login and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}!',
    'global.emails.team_member_create.body_register' => 'Hey there,<br /><br />You have been invited by <strong>{{USER_NAME}}</strong> ({{USER_EMAIL}}) to join the <strong>{{TEAM_NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}">register and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.user_data_send.subject' => 'New data collected for {{CAMPAIGN_NAME}} campaign - {{NOTIFICATION_NAME}} notification',
    'global.emails.user_data_send.body' => 'Here is everything we have collected from the <strong>{{CAMPAIGN_NAME}}</strong> Campaign - <strong>{{NOTIFICATION_NAME}}</strong> Notification.<br /><br />{{DATA}}<br /><br />Greetings from {{WEBSITE_TITLE}}!',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => 'Hey!<br /><br />A new user just registered to the website!<br /><br />Welcome to <strong>{{NAME}}</strong> ({{EMAIL}}) to your website!',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => 'Hey!<br /><br /><strong>{{NAME}}</strong> ({{EMAIL}}) user just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> to your website!<br /><br />Here\'s to more earnings!',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => 'Hey!<br /><br /><strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}">View affiliate withdrawal</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => 'Hey,<br /><br /><strong>{{NAME}}</strong> - {{EMAIL}} has sent you the following message:<br /><br />{{MESSAGE}}',

    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent. <button type="button" data-cc="c-settings" class="cc-link">Let me choose</button>',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.save' => 'Save settings',
    'global.cookie_consent.close' => 'Close',

    'global.footer.copyright' => 'Copyright © %1$s %2$s.',

    'global.plan_settings.no_ads' => 'No Ads',
    'global.plan_settings.removable_branding' => 'Removable Branding',
    'global.plan_settings.custom_branding' => 'Custom Branding',
    'global.plan_settings.campaigns_limit' => '%s Campaigns',
    'global.plan_settings.notifications_limit' => '%s Notifications',
    'global.plan_settings.notifications_impressions_limit' => '%s Impressions / month',
    'global.plan_settings.track_notifications_retention' => '%s days statistics retention',
    'global.plan_settings.enabled_notifications_all' => 'All Notifications Enabled',
    'global.plan_settings.enabled_notifications_x' => '%s Enabled Notifications',
    'global.plan_settings.api_is_enabled' => 'API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',
    'global.plan_settings.affiliate_is_enabled' => 'Affiliate access',
    'global.plan_settings.affiliate_is_enabled_help' => 'Get access to the affiliate program to earn money.',
    'global.plan_settings.teams_limit' => '%s teams',
    'global.plan_settings.team_members_limit' => '%s team members',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.last_datetime' => 'Last updated on: %s',

    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.total_views' => '(%s views)',

    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',

    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',

    'pages.pages_category.breadcrumb' => 'Pages Category',

    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select one plan to continue your subscription.',
    'plan.header_renew' => 'Renew your plan',
    'plan.subheader_renew' => 'Select one plan to renew your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one plan to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plan.button.choose' => 'Choose plan',
    'plan.button.renew' => 'Renew plan',
    'plan.button.trial' => 'Try for %s days',
    'plan.button.contact' => 'Contact us',

    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',

    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'Your already have the free plan activated!',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires!',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly Payments',
    'pay.custom_plan.annual' => 'Annual Payments',
    'pay.custom_plan.annual_savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'I have a discount/redeemable code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One Time Payment',
    'pay.custom_plan.recurring_type' => 'Recurring Payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.annual' => 'Yearly',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid..',
    'pay.error_message.code_used' => 'You have already used this code..',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',

    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',

    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s Plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade Plan',
    'account.plan.renew_plan' => 'Renew/Change Plan',
    'account.plan.renew' => 'Renew/Upgrade',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Basic profile settings of your account.',
    'account.settings.email' => 'Email',
    'account.settings.name' => 'Name',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',


    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.city' => 'City',
    'account.billing.county' => 'County',
    'account.billing.country' => 'Country',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',

    'account.change_password.header' => 'Change Password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current Password',
    'account.change_password.new_password' => 'New Password',
    'account.change_password.repeat_password' => 'Repeat Password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR Code',
    'account.twofa.qr_help' => 'Open the authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the following QR Code with your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR Code?',
    'account.twofa.secret_help' => 'Try inserting the following secret code into your app if you can\'t scan the QR Code.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, please enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',

    'account.error_message.invalid_current_password' => 'Your current password is not valid!',
    'account.error_message.twofa_check' => 'The token that you entered is not valid, please try again to setup the Two-factor authentication system.',

    'account.success_message.account_updated' => 'Your account was updated!',
    'account.success_message.password_updated' => 'Your account password was updated!',

    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. <br /> This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',

    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid!',
    'account_delete.success_message' => 'Your account was fully deleted! We\'re sorry to see you go!',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'account_plan.title' => 'Account Plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => 'Account Plan',

    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',

    'account_plan.cancel.header' => 'Cancel Subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel Subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',

    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled!',

    'account_payments.title' => 'Account Payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account Payments',
    'account_payments.subheader' => 'All the payments made on your account.',

    'account_payments.payments.customer' => 'Customer',
    'account_payments.payments.type' => 'Type',
    'account_payments.payments.date' => 'Date',
    'account_payments.payments.name' => 'Full Name',
    'account_payments.payments.total_amount' => 'Total Amount',
    'account_payments.payments.plan_id' => 'Plan',
    'account_payments.payments.invoice' => 'Invoice',
    'account_payments.payments.status_pending' => 'Pending approval',
    'account_payments.payments.status_approved' => 'Approved',
    'account_payments.payments.no_data' => 'No payments for now..',

    'account_payments.filters.processor' => 'Processor',
    'account_payments.filters.type' => 'Type',
    'account_payments.filters.type_one_time' => 'One time',
    'account_payments.filters.type_recurring' => 'Recurring',
    'account_payments.filters.frequency' => 'Frequency',
    'account_payments.filters.frequency_monthly' => 'Monthly',
    'account_payments.filters.frequency_annual' => 'Annual',
    'account_payments.filters.frequency_lifetime' => 'Lifetime',
    'account_payments.filters.order_by_total_amount' => 'Total amount',

    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',

    'account_logs.logs.type' => 'Type',
    'account_logs.logs.ip' => 'IP',
    'account_logs.logs.datetime' => 'Date',
    'account_logs.logs.details' => 'Details',
    'account_logs.logs.no_data' => 'Your account has no recorded logs..',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',

    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Your API key. If needed, you can get a new one by hitting the button below. Looking for the %sAPI Documentation?%s',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully!',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams system',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'My teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.input.name' => 'Name',
    'teams.table.members' => 'Members',
    'teams.table.datetime' => 'Created on',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_delete_modal.header' => 'Delete team',
    'team_delete_modal.subheader' => 'By deleting the team, all the data associated with the team will be lost. This action cannot be undone.',


    'team_members.create' => 'Invite member',
    'team_members.input.user_email' => 'Email',
    'team_members.input.access' => 'Access',
    'team_members.input.access_help' => 'Set what permissions you want to hand out to the user.',
    'team_members.input.access.read' => 'View',
    'team_members.input.access.create' => 'Create',
    'team_members.input.access.update' => 'Update',
    'team_members.input.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status' => 'Status',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited on',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.invalid_email' => 'This email is invalid.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'team_member_delete_modal.header' => 'Delete team member',
    'team_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member.title' => 'Teams member',
    'teams_member.menu' => 'Teams member',
    'teams_member.breadcrumb' => 'Teams member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited on',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.button' => 'Copy referral link',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid' => 'Is paid',
    'referrals.withdraw.is_paid_paid' => 'Paid!',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing!',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'INVOICE',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.city' => 'City',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.country' => 'Country',
    'invoice.email' => 'Email',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.table.item' => 'Item',
    'invoice.table.amount' => 'Amount',
    'invoice.table.plan' => '%s Plan',
    'invoice.table.frequency' => '%s access.',
    'invoice.table.frequency_monthly' => '30 days',
    'invoice.table.frequency_annual' => '1 year',
    'invoice.table.frequency_lifetime' => 'Lifetime',
    'invoice.table.code' => 'Discount',
    'invoice.table.code_help' => 'Code used: %s',
    'invoice.table.total' => 'Total',
    'invoice.table.paid_via' => 'Paid via %s',

    'login.menu' => 'Login',
    'login.title' => 'Login',
    'login.header' => 'Login',

    'login.form.email' => 'Email Address',
    'login.form.email_placeholder' => 'email@domain.com',
    'login.form.password' => 'Password',
    'login.form.password_placeholder' => 'Password',
    'login.form.twofa_token' => 'Two-factor token',
    'login.form.twofa_token_placeholder' => 'Token code from the authenticator app',
    'login.form.remember_me' => 'Remember me',
    'login.form.login' => 'Login',

    'login.display.total_track_notifications' => 'Displayed notifications worldwide and counting.',
    'login.display.register' => 'Don\'t have an account? %s',
    'login.display.register_help' => 'Register',
    'login.display.lost_password' => 'Lost Password',
    'login.display.resend_activation' => 'Resend Activation',
    'login.display.facebook' => 'Facebook Login',
    'login.display.google' => 'Google Login',
    'login.display.twitter' => 'Twitter Login',
    'login.display.discord' => 'Discord Login',

    'login.info_message.twofa_token' => 'Use your authenticator app to get the token for the Two-factor authentication.',
    'login.info_message.logged_in' => 'Welcome back, %s! You\'ve successfully logged in.',

    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid!',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid!',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned!',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',

    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.email' => 'Email',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We sent an email to you if there is an account registered with it!',

    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password was set!',

    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.email' => 'Email',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We sent an email to you if there is an account registered with it!',

    'activate_user.user_activation' => 'Your account has been confirmed and is now active!',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed!',

    'register.title' => 'Register',
    'register.menu' => 'Register',
    'register.header' => 'Register',
    'register.login' => 'Already have an account?',

    'register.display.total_notifications' => 'Total notifications created with our platform.',

    'register.form.name' => 'Name',
    'register.form.name_placeholder' => 'Your full name',
    'register.form.email' => 'Email',
    'register.form.email_placeholder' => 'email@domain.com',
    'register.form.password' => 'Password',
    'register.form.password_placeholder' => 'Password',
    'register.form.repeat_password' => 'Repeat Password',
    'register.form.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.form.register' => 'Register',

    'register.error_message.name_length' => 'Name must be between 1 and 64 characters!',
    'register.error_message.email_exists' => 'This email address is already in use!',
    'register.error_message.invalid_email' => 'This email address is invalid!',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted!',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted!',

    'register.success_message.registration' => 'Check your email for the activation link of your account!',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here!',


    'dashboard.title' => 'Dashboard',
    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.header' => 'Dashboard',
    'dashboard.view_all' => 'View all',
    'dashboard.total_campaigns' => '%s campaigns',
    'dashboard.total_notifications' => '%s notifications',
    'dashboard.total_notifications_impressions' => '%1$s / %2$s impressions',
    'dashboard.campaigns_header' => 'Latest campaigns',
    'dashboard.notifications_header' => 'Latest notifications',


    'campaigns.breadcrumb' => 'Campaigns',
    'campaigns.title' => 'Campaigns',
    'campaigns.menu' => 'Campaigns',
    'campaigns.header' => 'Campaigns',
    'campaigns.subheader' => 'A campaign can be used to create multiple widget notifications for a specific domain.',
    'campaigns.create' => 'Create campaign',

    'campaigns.table.campaign' => 'Name',
    'campaigns.table.datetime' => 'Created on',
    'campaigns.table.is_enabled' => 'Status',
    'campaigns.table.is_enabled_tooltip' => 'Change the status',

    'campaigns.input.name' => 'Name',
    'campaigns.input.domain' => 'Domain',
    'campaigns.input.domain_placeholder' => 'ex: domain.com or subdomain.domain.com',
    'campaigns.input.domain_help' => 'The domain name of the website where the campaign is going to run.',
    'campaigns.input.domain_help2' => 'Notifications will NOT work on other domains other than what you define here.',
    'campaigns.input.include_subdomains' => 'Include Subdomains',
    'campaigns.input.include_subdomains_help' => 'All the subdomains will match on this campaign as well if checked.',

    'campaigns.no_data' => 'There are no campaigns available.',


    'campaign.title' => 'Campaign - %s',
    'campaign.breadcrumb' => 'Campaign',

    'campaign.custom_branding' => 'Custom Branding',
    'campaign.pixel_key' => 'Install Pixel',

    'campaign.notifications.link' => 'Notifications',
    'campaign.notifications.header' => 'Notifications',

    'campaign.statistics.disabled' => 'Statistics for campaigns are not enabled.',
    'campaign.statistics.header' => 'Statistics',
    'campaign.statistics.link' => 'Statistics',
    'campaign.statistics.impressions_chart' => 'Impressions',
    'campaign.statistics.hovers_chart' => 'Mouse Hovers',
    'campaign.statistics.clicks_chart' => 'Clicks',
    'campaign.statistics.form_submissions_chart' => 'Form Submissions',
    'campaign.statistics.no_data' => 'There is no data for this date range unfortunately.',


    'custom_branding_campaign_modal.header' => 'Custom Branding',
    'custom_branding_campaign_modal.subheader' => 'Create your own custom branding for your notifications.',
    'custom_branding_campaign_modal.input.name' => 'Branding Name',
    'custom_branding_campaign_modal.input.name_help' => 'Leave empty to have the default site branding.',
    'custom_branding_campaign_modal.input.url' => 'URL',


    'create_campaign_modal.header' => 'Create a new campaign',
    'create_campaign_modal.subheader' => 'Easily create a new campaign by filling the following information.',


    'update_campaign_modal.header' => 'Edit campaign',
    'update_campaign_modal.subheader' => 'Change an already existing campaign.',


    'campaign_pixel_key_modal.install.header' => 'Install Pixel',
    'campaign_pixel_key_modal.install.subheader' => 'Copy and paste the following JS Code Snippet before the end of the <code>head</code> tag of your website.',
    'campaign_pixel_key_modal.install.copy' => 'Copy Pixel',
    'campaign_pixel_key_modal.install.copied' => 'Copied!',


    'campaign_delete_modal.header' => 'Delete campaign',
    'campaign_delete_modal.subheader' => 'By deleting the campaign, all the data associated with the campaign will be lost. This action cannot be undone.',


    'notifications.header' => 'Campaign notifications',
    'notifications.create' => 'Create notification',
    'notifications.link' => 'Notifications',

    'notifications.filters.type' => 'Type',
    'notifications.filters.name' => 'Name',

    'notifications.table.name' => 'Notification',
    'notifications.table.type' => 'Type',
    'notifications.table.display_trigger' => 'Trigger',
    'notifications.table.display_duration' => 'Duration',
    'notifications.table.is_enabled' => 'Status',
    'notifications.table.is_enabled_tooltip' => 'Change the status',
    'notifications.table.display_duration_unlimited' => 'Forever',
    'notifications.no_data' => 'There are no notifications available.',


    'notification.breadcrumb' => 'Notification',
    'notification.title' => 'Notification - %s',

    'notification.preview.header' => 'Preview',
    'notification.preview.subheader' => 'Overall preview of how it would look like.',

    'notification.settings.header' => 'Settings',
    'notification.settings.link' => 'Settings',
    'notification.settings.tab_basic' => 'Basic',
    'notification.settings.tab_triggers' => 'Triggers',
    'notification.settings.tab_display' => 'Display',
    'notification.settings.tab_customize' => 'Customize',
    'notification.settings.tab_data' => 'Data',
    'notification.settings.name' => 'Notification name',
    'notification.settings.title' => 'Title Message',
    'notification.settings.description' => 'Description Message',
    'notification.settings.content_title' => 'Content Title',
    'notification.settings.content_description' => 'Content Description',
    'notification.settings.video' => 'YouTube Video Embed Url',
    'notification.settings.video_help' => 'Allowed formats: https://www.youtube.com/embed/VIDEO_ID or https://www.youtube.com/watch?v=VIDEO_ID',
    'notification.settings.last_activity' => 'Count data from last X %s',
    'notification.settings.conversion_title' => 'Conversion Title',
    'notification.settings.conversion_title_help' => 'You can insert dynamic variables from your Conversion Data. Example: If you have a field named <code>full_name</code>, you can use it as <code>{full_name}</code>.',
    'notification.settings.conversion_description' => 'Conversion Description',
    'notification.settings.conversion_active_help' => 'You can insert dynamic variables from your Conversion Data as mentioned in the Conversion Title.',
    'notification.settings.order' => 'Display order',
    'notification.settings.order_descending' => 'Descending',
    'notification.settings.order_random' => 'Random',
    'notification.settings.conversions_count' => 'How many conversions to show?',
    'notification.settings.conversions_count_help' => '',
    'notification.settings.in_between_delay' => 'In between delay',
    'notification.settings.in_between_delay_help' => 'Written in seconds',
    'notification.settings.reviews_count' => 'How many reviews to show?',
    'notification.settings.reviews_count_help' => '',
    'notification.settings.input_placeholder' => 'Input Placeholder',
    'notification.settings.email_placeholder' => 'Email Placeholder',
    'notification.settings.image' => 'Image URL',
    'notification.settings.image_help' => 'Leave empty for no image. Hint: icons8.com has a good library of small icons that you can use.',
    'notification.settings.image_alt' => 'Image Alt',
    'notification.settings.image_alt_help' => 'Image description for accessibility and SEO purposes.',
    'notification.settings.url' => 'Notification URL',
    'notification.settings.url_help' => 'The URL you want to user to go to after clicking the notification. Leave empty for no link.',
    'notification.settings.url_new_tab' => 'On click open on new tab',
    'notification.settings.url_new_tab_help' => '',
    'notification.settings.url_link' => 'Link URL',
    'notification.settings.url_link_text' => 'Link URL Text',
    'notification.settings.thank_you_url' => 'Thank you URL',
    'notification.settings.thank_you_url_help' => 'The URL the user will be redirected to after submitting the form. Leave empty to disable the function.',
    'notification.settings.coupon_code' => 'Coupon Code',
    'notification.settings.button_url' => 'Button Url',
    'notification.settings.button_text' => 'Button Text',
    'notification.settings.button_text_help' => 'Leave empty to remove the button completely.',
    'notification.settings.footer_text' => 'Footer Text',
    'notification.settings.share_url' => 'Share URL',
    'notification.settings.share_url_help' => 'Leave empty if you want the URL to be dynamic to the current page where the notification is shown.',
    'notification.settings.share_facebook' => 'Facebook Share',
    'notification.settings.share_twitter' => 'Twitter Share',
    'notification.settings.share_linkedin' => 'Linkedin Share',
    'notification.settings.show_angry' => 'Show Angry',
    'notification.settings.show_sad' => 'Show Sad',
    'notification.settings.show_neutral' => 'Show Neutral',
    'notification.settings.show_happy' => 'Show Happy',
    'notification.settings.show_excited' => 'Show Excited',
    'notification.settings.end_date' => 'End Date',
    'notification.settings.show_agreement' => 'Show Agreement',
    'notification.settings.show_agreement_help' => 'Require the user to confirm his agreement by ticking a checkbox.',
    'notification.settings.agreement_url' => 'Agreement URL',
    'notification.settings.agreement_text' => 'Agreement Text',
    'notification.settings.html' => 'Custom HTML',
    'notification.settings.html_help' => 'Use <code>{CLOSE_BUTTON}</code> to add a close button if needed.',
    'notification.settings.trigger_all_pages' => 'Trigger on all pages',
    'notification.settings.trigger_all_pages_help' => 'Where should the notification show?',
    'notification.settings.trigger_add' => 'Add new trigger',
    'notification.settings.trigger_type_exact' => 'Exact match',
    'notification.settings.trigger_type_not_exact' => 'Does not match exact',
    'notification.settings.trigger_type_contains' => 'Contains',
    'notification.settings.trigger_type_not_contains' => 'Does not contain',
    'notification.settings.trigger_type_starts_with' => 'Starts with',
    'notification.settings.trigger_type_not_starts_with' => 'Does not start with',
    'notification.settings.trigger_type_ends_with' => 'Ends with',
    'notification.settings.trigger_type_not_ends_with' => 'Does not end with',
    'notification.settings.trigger_type_page_contains' => 'Page Contains',
    'notification.settings.trigger_type_exact_placeholder' => 'Full URL ( ex: https://domain.com )',
    'notification.settings.trigger_type_not_exact_placeholder' => 'Full URL ( ex: https://domain.com )',
    'notification.settings.trigger_type_contains_placeholder' => 'Part of the URL ( ex: /product/102481 )',
    'notification.settings.trigger_type_not_contains_placeholder' => 'Part of the URL ( ex: /product/102481 )',
    'notification.settings.trigger_type_starts_with_placeholder' => 'Part of the URL',
    'notification.settings.trigger_type_not_starts_with_placeholder' => 'Part of the URL',
    'notification.settings.trigger_type_ends_with_placeholder' => 'Part of the URL',
    'notification.settings.trigger_type_not_ends_with_placeholder' => 'Part of the URL',
    'notification.settings.trigger_type_page_contains_placeholder' => 'Text that is included in the website',
    'notification.settings.display_trigger' => 'Display Trigger',
    'notification.settings.display_trigger_help' => 'On what event the notification should show up.',
    'notification.settings.display_trigger_delay' => 'Delay',
    'notification.settings.display_trigger_delay_placeholder' => 'Number of seconds to wait until notification shows up',
    'notification.settings.display_trigger_scroll' => 'Scroll Percentage',
    'notification.settings.display_trigger_scroll_placeholder' => 'Percent of scrolling from the top down',
    'notification.settings.display_trigger_exit_intent' => 'Exit Intent',
    'notification.settings.display_frequency' => 'Display frequency',
    'notification.settings.display_frequency_help' => 'How often should the notification trigger?.',
    'notification.settings.display_frequency_all_time' => 'All the time',
    'notification.settings.display_frequency_once_per_session' => 'Once per visit session',
    'notification.settings.display_frequency_once_per_browser' => 'Once per browser',
    'notification.settings.display_mobile' => 'Display on small screens',
    'notification.settings.display_mobile_help' => 'Whether or not to display the notification on when pixels available are smaller than 768px.',
    'notification.settings.display_desktop' => 'Display on large screens',
    'notification.settings.display_desktop_help' => 'Whether or not to display the notification on when pixels available are bigger than 768px.',
    'notification.settings.display_duration' => 'Display Duration',
    'notification.settings.display_duration_help' => 'How many seconds to display the notification. Set -1 to display forever.',
    'notification.settings.direction' => 'Direction',
    'notification.settings.direction_ltr' => 'Left to right',
    'notification.settings.direction_rtl' => 'Right to left',
    'notification.settings.display_position' => 'Display Position',
    'notification.settings.display_position_help' => 'Position of the notification on the screen. Position doesn\'t change on the preview.',
    'notification.settings.display_position_top_left' => 'Top Left',
    'notification.settings.display_position_top_center' => 'Top Center',
    'notification.settings.display_position_top_right' => 'Top Right',
    'notification.settings.display_position_middle_left' => 'Middle Left',
    'notification.settings.display_position_middle_center' => 'Middle Center',
    'notification.settings.display_position_middle_right' => 'Middle Right',
    'notification.settings.display_position_bottom_left' => 'Bottom Left',
    'notification.settings.display_position_bottom_center' => 'Bottom Center',
    'notification.settings.display_position_bottom_right' => 'Bottom Right',
    'notification.settings.display_position_top' => 'Top',
    'notification.settings.display_position_bottom' => 'Bottom',
    'notification.settings.display_position_top_floating' => 'Top Floating',
    'notification.settings.display_position_bottom_floating' => 'Bottom Floating',
    'notification.settings.display_minimum_activity' => 'Minimum activity',
    'notification.settings.display_minimum_activity_help' => 'Minimum data needed to display the notification.',
    'notification.settings.display_close_button' => 'Display Close Button',
    'notification.settings.display_branding' => 'Display Branding',
    'notification.settings.on_animation' => 'Entrance Animation',
    'notification.settings.on_animation_fadeIn' => 'Fade In',
    'notification.settings.on_animation_slideInUp' => 'Slide In Up',
    'notification.settings.on_animation_slideInDown' => 'Slide In Down',
    'notification.settings.on_animation_zoomIn' => 'Zoom In',
    'notification.settings.on_animation_bounceIn' => 'Bounce In',
    'notification.settings.off_animation' => 'Exit Animation',
    'notification.settings.off_animation_fadeOut' => 'Fade Out',
    'notification.settings.off_animation_slideOutUp' => 'Slide Out Up',
    'notification.settings.off_animation_slideOutDown' => 'Slide Out Down',
    'notification.settings.off_animation_zoomOut' => 'Zoom Out',
    'notification.settings.off_animation_bounceOut' => 'Bounce Out',
    'notification.settings.font' => 'Font',
    'notification.settings.font_inherit' => 'Inherit from website',
    'notification.settings.title_color' => 'Title color',
    'notification.settings.description_color' => 'Description color',
    'notification.settings.content_title_color' => 'Content Title color',
    'notification.settings.content_description_color' => 'Content description color',
    'notification.settings.close_button_color' => 'Close button color',
    'notification.settings.background_color' => 'Background color',
    'notification.settings.background_pattern' => 'Background pattern',
    'notification.settings.background_pattern_none' => 'None',
    'notification.settings.background_pattern_jupiter' => 'Jupiter',
    'notification.settings.background_pattern_wavy' => 'Wavy',
    'notification.settings.background_pattern_hexagons' => 'Hexagons',
    'notification.settings.background_pattern_autumn' => 'Autumn',
    'notification.settings.background_pattern_shapes' => 'Shapes',
    'notification.settings.background_pattern_anchors' => 'Anchors',
    'notification.settings.background_pattern_plus' => 'Plus',
    'notification.settings.background_pattern_bubbles' => 'Bubbles',
    'notification.settings.background_pattern_wiggle' => 'Wiggle',
    'notification.settings.button_background_color' => 'Button background color',
    'notification.settings.button_color' => 'Button color',
    'notification.settings.number_color' => 'Number color',
    'notification.settings.coupon_code_color' => 'Coupon code color',
    'notification.settings.coupon_code_background_color' => 'Coupon code background color',
    'notification.settings.coupon_code_border_color' => 'Coupon code border color',
    'notification.settings.number_background_color' => 'Number background color',
    'notification.settings.pulse_background_color' => 'Pulse background color',
    'notification.settings.time_color' => 'Time color',
    'notification.settings.time_background_color' => 'Time background color',
    'notification.settings.border_width' => 'Border width',
    'notification.settings.border_width_help' => 'Value from 0 to 5 for the border width of the notification.',
    'notification.settings.border_color' => 'Border color',
    'notification.settings.border_radius' => 'Border radius',
    'notification.settings.border_radius_help' => 'Change the shape of the corners of the notification',
    'notification.settings.border_radius_straight' => 'Straight',
    'notification.settings.border_radius_rounded' => 'Rounded',
    'notification.settings.border_radius_round' => 'Round',
    'notification.settings.shadow' => 'Display shadow',
    'notification.settings.shadow_help' => 'Enable or disable the shadow around the edges of the notification',
    'notification.settings.engagement_links_categories' => 'Categories',
    'notification.settings.engagement_links_categories_links' => 'Categories links',
    'notification.settings.data_send_is_enabled' => 'Send caught data to external sources',
    'notification.settings.data_send_webhook' => 'Webhook',
    'notification.settings.data_send_webhook_help' => 'Leave empty to disable this field.',
    'notification.settings.data_send_webhook_placeholder' => 'Webhook URL',
    'notification.settings.data_send_email' => 'Email',
    'notification.settings.data_send_email_help' => 'Leave empty to disable this field.',
    'notification.settings.data_send_email_placeholder' => 'Valid email address',
    'notification.settings.data_trigger_webhook' => 'Webhook Trigger',
    'notification.settings.data_trigger_webhook_help' => 'Call the endpoint to let us know about an event or conversion that happened on your website related to this notification, we\'ll do the rest. The call MUST be a POST request and can have any form data parameters.',
    'notification.settings.data_trigger_type_webhook' => 'Webhook',
    'notification.settings.data_trigger_input_webhook' => 'Full Webhook Url',
    'notification.settings.data_trigger_auto' => 'Auto Capture Data',
    'notification.settings.data_trigger_auto_help' => 'Setting the Auto Capture option will try to automatically detect when a form has been submitted and record that data for you. ( Password fields will never be captured )',
    'notification.settings.data_trigger_auto_add' => 'Add new rule',

    'notification.statistics.disabled' => 'Statistics for notifications are not enabled.',
    'notification.statistics.header' => 'Statistics',
    'notification.statistics.link' => 'Statistics',
    'notification.statistics.impressions_chart' => 'Impressions',
    'notification.statistics.hovers_chart' => 'Mouse Hovers',
    'notification.statistics.clicks_chart' => 'Clicks',
    'notification.statistics.form_submissions_chart' => 'Form Submissions',
    'notification.statistics.feedback_chart' => 'Feedback Submissions',
    'notification.statistics.header_feedback' => 'Feedbacks',
    'notification.statistics.feedback' => 'Feedback',
    'notification.statistics.feedback_total' => 'Count',
    'notification.statistics.header_top_pages' => 'Top Pages',
    'notification.statistics.subheader_top_pages' => 'Most active pages on which notifications had most activity.',
    'notification.statistics.url' => '',
    'notification.statistics.type' => '',
    'notification.statistics.pageviews' => 'Pageviews',
    'notification.statistics.impression' => 'Impression',
    'notification.statistics.hover' => 'Hover',
    'notification.statistics.form_submission' => 'Form Submission',
    'notification.statistics.click' => 'Click',
    'notification.statistics.auto_capture' => 'Auto Capture',
    'notification.statistics.feedback_emoji_angry' => 'Emoji Angry',
    'notification.statistics.feedback_emoji_sad' => 'Emoji Sad',
    'notification.statistics.feedback_emoji_neutral' => 'Emoji Neutral',
    'notification.statistics.feedback_emoji_happy' => 'Emoji Happy',
    'notification.statistics.feedback_emoji_excited' => 'Emoji Excited',
    'notification.statistics.feedback_score_1' => 'Score 1',
    'notification.statistics.feedback_score_2' => 'Score 2',
    'notification.statistics.feedback_score_3' => 'Score 3',
    'notification.statistics.feedback_score_4' => 'Score 4',
    'notification.statistics.feedback_score_5' => 'Score 5',

    'notification.data.header' => 'Data',
    'notification.data.link' => 'Data',
    'notification.data.create' => 'Import Data',
    'notification.data.expand_data' => 'Click to get conversion data',
    'notification.data.no_data' => 'No data',
    'notification.data.data' => 'Data',
    'notification.data.url' => 'URL',
    'notification.data.date' => 'Date',
    'notification.data.ip' => 'IP',
    'notification.data.country' => 'Country',
    'notification.data.city' => 'City',
    'notification.data.country_code' => 'Country code',
    'notification.data.variable' => 'Can also be used as a variable {%s}',
    'notification.data.type' => 'Type',
    'notification.data.type_auto_capture' => 'Auto Captured',
    'notification.data.type_webhook' => 'Webhook',
    'notification.data.type_imported' => 'Imported',
    'notification.data.type_email_collector' => 'Email Collected',
    'notification.data.type_collector' => 'Collected',

    'notification.create_data_modal.header' => 'Import / Create Data',
    'notification.create_data_modal.create_key_value' => 'Add field',

    'notification.create_data_modal.input.key' => 'Key / Field Name',
    'notification.create_data_modal.input.key_placeholder' => 'name',
    'notification.create_data_modal.input.value' => 'Value',
    'notification.create_data_modal.input.value_placeholder' => 'John Doe',

    'notification.create_review_data_modal.header' => 'Create new review',

    'notification.create_review_data_modal.input.title' => 'Name',
    'notification.create_review_data_modal.input.description' => 'Text',
    'notification.create_review_data_modal.input.stars' => 'Stars',
    'notification.create_review_data_modal.input.stars_help' => 'Leave empty to not show any stars in the review.',

    'notification.info_message.no_data' => 'There is no data for this date range unfortunately.',

    'notification.informational.name' => 'Informational',
    'notification.informational.description' => 'Fully customizable informational message for your users.',
    'notification.informational.icon' => 'fa fa-fw fa-info-circle',
    'notification.informational.title_default' => 'Flash sale!',
    'notification.informational.description_default' => 'Limited sale until tonight, right now!',
    'notification.informational.image_default' => 'https://img.icons8.com/dusk/2x/sale.png',

    'notification.coupon.name' => 'Coupon',
    'notification.coupon.description' => 'The best way to let your users know that you are running a sale.',
    'notification.coupon.icon' => 'fa fa-fw fa-piggy-bank',
    'notification.coupon.title_default' => '35% OFF!',
    'notification.coupon.description_default' => 'Limited summer sale coupon code!',
    'notification.coupon.image_default' => 'https://img.icons8.com/nolan/2x/cutting-coupon.png',
    'notification.coupon.coupon_code_default' => 'COUPON20',
    'notification.coupon.button_text_default' => 'Get Coupon',
    'notification.coupon.footer_text_default' => 'No, I don\'t want to save money!',

    'notification.live_counter.name' => 'Live Counter',
    'notification.live_counter.description' => 'Show your visitors how many people are on your site to create more trust.',
    'notification.live_counter.icon' => 'fa fa-fw fa-globe',
    'notification.live_counter.description_default' => 'Active visitors now.',
    'notification.live_counter.image_default' => 'https://img.icons8.com/nolan/2x/cutting-coupon.png',
    'notification.live_counter.number_default' => '15',

    'notification.email_collector.name' => 'Email Collector',
    'notification.email_collector.description' => 'Easily collect emails and generate leads from your users.',
    'notification.email_collector.icon' => 'fa fa-fw fa-envelope-open',
    'notification.email_collector.title_default' => 'Weekly newsletter',
    'notification.email_collector.description_default' => 'We do not send out spam emails & you can unsubscribe at any point.',
    'notification.email_collector.email_placeholder_default' => 'Your valid email',
    'notification.email_collector.button_text_default' => 'Sign me up',
    'notification.email_collector.agreement_text_default' => 'I read & agree the Privacy Policy',

    'notification.conversions.name' => 'Conversions',
    'notification.conversions.description' => 'Establish social proof by displaying your most recent conversions on your site.',
    'notification.conversions.icon' => 'fa fa-fw fa-funnel-dollar',
    'notification.conversions.title_default' => 'Someone from England',
    'notification.conversions.description_default' => 'Signed up for the newsletter.',
    'notification.conversions.image_default' => 'https://img.icons8.com/dusk/2x/small-smile.png',
    'notification.conversions.time_ago_default' => '10 mins ago',

    'notification.conversions_counter.name' => 'Conversions Counter',
    'notification.conversions_counter.description' => 'Establish social proof by showing how many recent conversions you\'ve got.',
    'notification.conversions_counter.icon' => 'fa fa-fw fa-comment-dollar',
    'notification.conversions_counter.title_default' => 'People bought the product',
    'notification.conversions_counter.image_default' => 'https://img.icons8.com/officel/2x/return-purchase.png',
    'notification.conversions_counter.number_default' => '5',
    'notification.conversions_counter.time_default' => 'In the last %s hours',

    'notification.video.name' => 'Video',
    'notification.video.description' => 'Easily display a small widget with an informative YouTube video.',
    'notification.video.icon' => 'fa fa-fw fa-video',
    'notification.video.title_default' => 'Demo of the product',
    'notification.video.thumbnail_default' => 'https://i3.ytimg.com/vi/3WxQgvuT6ZI/maxresdefault.jpg',
    'notification.video.button_text_default' => 'Sign up',

    'notification.social_share.name' => 'Social Share',
    'notification.social_share.description' => 'Let others share your content and generate more traffic for you.',
    'notification.social_share.icon' => 'fa fa-fw fa-share-alt',
    'notification.social_share.title_default' => 'Tell your friends',
    'notification.social_share.description_default' => 'We appreciate all the shares to support us! Thank you!',

    'notification.reviews.name' => 'Reviews',
    'notification.reviews.description' => 'Display a review/testimonial from your clients to create social proof.',
    'notification.reviews.icon' => 'fa fa-fw fa-random',
    'notification.reviews.title_default' => 'John Doe',
    'notification.reviews.description_default' => 'Thank you very much for providing this awesome service!',
    'notification.reviews.image_default' => 'https://img.icons8.com/external-vitaliy-gorbachev-blue-vitaly-gorbachev/344/external-review-social-media-vitaliy-gorbachev-blue-vitaly-gorbachev.png',

    'notification.emoji_feedback.name' => 'Emoji Feedback',
    'notification.emoji_feedback.description' => 'An interactive way for your users to give you feedback about your site.',
    'notification.emoji_feedback.icon' => 'fa fa-fw fa-smile-beam',
    'notification.emoji_feedback.title_default' => 'Do you like our website?',
    'notification.emoji_feedback.feedback_emoji_angry' => 'Angry',
    'notification.emoji_feedback.feedback_emoji_sad' => 'Sad',
    'notification.emoji_feedback.feedback_emoji_neutral' => 'Neutral',
    'notification.emoji_feedback.feedback_emoji_happy' => 'Happy',
    'notification.emoji_feedback.feedback_emoji_excited' => 'Excited',

    'notification.cookie_notification.name' => 'Cookie Notification',
    'notification.cookie_notification.description' => 'Notify your users that you are using cookies on your site.',
    'notification.cookie_notification.icon' => 'fa fa-fw fa-cookie',
    'notification.cookie_notification.description_default' => 'This website uses cookies to ensure you get the best experience on our website.',
    'notification.cookie_notification.button_text_default' => 'Okay',
    'notification.cookie_notification.url_text_default' => 'Learn More',
    'notification.cookie_notification.image_default' => 'https://img.icons8.com/plasticine/2x/cookie.png',

    'notification.score_feedback.name' => 'Score Feedback',
    'notification.score_feedback.description' => 'The easiest way for your users to give you a score feedback.',
    'notification.score_feedback.icon' => 'fa fa-fw fa-sort-numeric-up',
    'notification.score_feedback.title_default' => 'How\'d you like our website?',
    'notification.score_feedback.description_default' => 'Rate from 1 to 5. 5 being excellent.',
    'notification.score_feedback.feedback_score_1' => '1',
    'notification.score_feedback.feedback_score_2' => '2',
    'notification.score_feedback.feedback_score_3' => '3',
    'notification.score_feedback.feedback_score_4' => '4',
    'notification.score_feedback.feedback_score_5' => '5',

    'notification.request_collector.name' => 'Request Collector',
    'notification.request_collector.description' => 'Collecting leads has never been easier with the request collector.',
    'notification.request_collector.icon' => 'fa fa-fw fa-user-plus',
    'notification.request_collector.title_default' => 'John',
    'notification.request_collector.description_default' => 'Support Team',
    'notification.request_collector.image_default' => 'https://img.icons8.com/cotton/2x/online-support.png',
    'notification.request_collector.content_title_default' => 'Any questions?',
    'notification.request_collector.content_description_default' => 'Let us know and we will get back to you!',
    'notification.request_collector.input_placeholder_default' => 'Valid Phone Number',
    'notification.request_collector.button_text_default' => 'Call me back ⚡️',
    'notification.request_collector.agreement_text_default' => 'I read & agree the Privacy Policy',

    'notification.countdown_collector.name' => 'Countdown Collector',
    'notification.countdown_collector.description' => 'Create urgency/FOMO with a countdown timer and an input for lead generation.',
    'notification.countdown_collector.icon' => 'fa fa-fw fa-clock',
    'notification.countdown_collector.title_default' => 'Building a website 💻',
    'notification.countdown_collector.description_default' => 'Free Webinar by us.',
    'notification.countdown_collector.content_title_default' => 'Hurry up! Registrations are closing soon.',
    'notification.countdown_collector.input_placeholder_default' => 'Valid Email',
    'notification.countdown_collector.button_text_default' => 'Sign up️',
    'notification.countdown_collector.agreement_text_default' => 'I read & agree the Privacy Policy',
    'notification.countdown_collector.days' => 'days',
    'notification.countdown_collector.hours' => 'hours',
    'notification.countdown_collector.minutes' => 'minutes',
    'notification.countdown_collector.seconds' => 'seconds',

    'notification.custom_html.name' => 'Custom HTML',
    'notification.custom_html.description' => 'Fully customizable notification widget.',
    'notification.custom_html.icon' => 'fa fa-fw fa-code',

    'notification.informational_bar.name' => 'Informational Bar',
    'notification.informational_bar.description' => 'Fully customizable informational bar for the top or bottom.',
    'notification.informational_bar.icon' => 'fa fa-fw fa-info',
    'notification.informational_bar.title_default' => 'Your title here',
    'notification.informational_bar.description_default' => 'Your description will go here!',
    'notification.informational_bar.image_default' => 'https://img.icons8.com/cute-clipart/2x/info.png',

    'notification.image.name' => 'Image',
    'notification.image.description' => 'Display a small widget with an informative Image of your choice.',
    'notification.image.icon' => 'fa fa-fw fa-image',
    'notification.image.title_default' => 'This is a demo title',
    'notification.image.image_default' => 'https://images.unsplash.com/photo-1592142484268-342bdc296658?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=334&q=80',
    'notification.image.button_text_default' => 'Register',

    'notification.collector_bar.name' => 'Collector Bar',
    'notification.collector_bar.description' => 'Collect emails or leads without distracting the users.',
    'notification.collector_bar.icon' => 'fa fa-fw fa-inbox',
    'notification.collector_bar.title_default' => 'Sign up to receive updates & discounts via email',
    'notification.collector_bar.input_placeholder_default' => 'Your valid email',
    'notification.collector_bar.button_text_default' => 'Subscribe',
    'notification.collector_bar.agreement_text_default' => 'I read & agree the Privacy Policy',

    'notification.coupon_bar.name' => 'Coupon Bar',
    'notification.coupon_bar.description' => 'Top or bottom simple bar to give your visitors a nice coupon for them to use.',
    'notification.coupon_bar.icon' => 'fa fa-fw fa-money-check-alt',
    'notification.coupon_bar.title_default' => 'We\'re running a limited sale until the end of the day 🙌',
    'notification.coupon_bar.coupon_code_default' => 'SALE15',

    'notification.button_bar.name' => 'Button Bar',
    'notification.button_bar.description' => 'Top or bottom cool bar to promote anything to your visitors.',
    'notification.button_bar.icon' => 'fa fa-fw fa-newspaper',
    'notification.button_bar.title_default' => 'We just launched our new product feature',
    'notification.button_bar.button_text_default' => 'Check product',

    'notification.collector_modal.name' => 'Modal Collector',
    'notification.collector_modal.description' => 'Collect leads with a nice looking and big modal.',
    'notification.collector_modal.icon' => 'fa fa-fw fa-fire',
    'notification.collector_modal.title_default' => 'Sign up',
    'notification.collector_modal.description_default' => 'We do not send out spam emails & you can unsubscribe at any point.',
    'notification.collector_modal.image_default' => '',
    'notification.collector_modal.input_placeholder_default' => 'Your valid email',
    'notification.collector_modal.button_text_default' => 'Sign me up',
    'notification.collector_modal.agreement_text_default' => 'I read & agree the Privacy Policy',

    'notification.collector_two_modal.name' => 'Modal Two Collector',
    'notification.collector_two_modal.description' => 'Collect leads with a nice looking and big modal.',
    'notification.collector_two_modal.icon' => 'fa fa-fw fa-dice',
    'notification.collector_two_modal.title_default' => 'Get discounts & latest offers via email',
    'notification.collector_two_modal.description_default' => 'We do not send out spam emails & you can unsubscribe at any point.',
    'notification.collector_two_modal.image_default' => '',
    'notification.collector_two_modal.input_placeholder_default' => 'Your valid email',
    'notification.collector_two_modal.button_text_default' => 'Sign up',
    'notification.collector_two_modal.agreement_text_default' => 'I read & agree the Privacy Policy',

    'notification.button_modal.name' => 'Call to action',
    'notification.button_modal.description' => 'Raise awareness and cta with a nice looking modal.',
    'notification.button_modal.icon' => 'fa fa-fw fa-cloud',
    'notification.button_modal.title_default' => 'New product',
    'notification.button_modal.description_default' => 'We just launched our new product, check it out right now!',
    'notification.button_modal.image_default' => 'https://altumcode.com/themes/altum/assets/images/altumcode.svg',
    'notification.button_modal.button_text_default' => 'Download for free',

    'notification.text_feedback.name' => 'Text Feedback',
    'notification.text_feedback.description' => 'Collect better and straight forward insight from your users.',
    'notification.text_feedback.icon' => 'fa fa-fw fa-heading',
    'notification.text_feedback.title_default' => 'Any suggestions for us?',
    'notification.text_feedback.description_default' => 'Let us know how we can do better 🙏.',
    'notification.text_feedback.input_placeholder_default' => 'Your honest input',
    'notification.text_feedback.button_text_default' => 'Submit',

    'notification.engagement_links.name' => 'Engagement Links',
    'notification.engagement_links.description' => 'Display a subtle widget which contains all of your relevant links.',
    'notification.engagement_links.icon' => 'fa fa-fw fa-link',
    'notification.engagement_links.title' => 'Connect with us 👋',


    'notification_delete_modal.header' => 'Delete notification',
    'notification_delete_modal.subheader' => 'By deleting the notification, all the data associated with the notification will be lost. This action cannot be undone.',


    'notification_create.breadcrumb' => 'Create a new notification',
    'notification_create.title' => 'Create a new notification',
    'notification_create.header' => 'Create a new notification',
    'notification_create.default_name' => 'My new notification',

    'index.title' => 'Increase Conversions & Site Growth',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.header' => '<span class="underline">Skyrocket</span> Conversions<br /> & Increase <span class="underline">Growth</span>.',
    'index.subheader' => '<strong>%s notifications</strong> were created & customized by our users.<br />Increase your website\'s growth by using our notification widgets.',
    'index.sign_up' => 'Get started',
    'index.breadcrumb' => 'Home',

    'index.steps.one' => 'Install pixel',
    'index.steps.one_text' => 'With just one line of code.',
    'index.steps.two' => 'Create notification',
    'index.steps.two_text' => 'Setup & customize your notification.',
    'index.steps.three' => 'Grow & profit',
    'index.steps.three_text' => 'Generate conversions & growth.',

    'index.setup.header' => 'Easy setup & integration on <span class="text-primary">any website</span>.',
    'index.setup.shopify' => 'Shopify',
    'index.setup.wordpress' => 'Wordpress',
    'index.setup.zapier' => 'Zapier',
    'index.setup.squarespace' => 'Squarespace',

    'index.tools.header' => '%s notifications displayed',
    'index.tools.subheader' => 'The proper social proof and utility widgets',
    'index.tools.preview' => 'Notification Preview',
    'index.tools.preview_description' => 'Choose any type of notification and preview it live.',

    'index.pricing.header' => 'Choose your plan',
    'index.pricing.subheader' => 'Choose the plan that is right for you and your budget.',

    'index.cta.header' => 'Sign up now',
    'index.cta.subheader' => 'Start upgrading your website with our widgets.',
    'index.cta.sign_up' => 'Get started',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',

    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'Get API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.details' => 'Details',
    'api_documentation.description' => 'Description',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',

    'api_documentation.user.breadcrumb' => 'User',
    'api_documentation.user.title' => 'User API Documentation',
    'api_documentation.user.header' => 'User',
    'api_documentation.user.read_header' => 'Retrieve user',

    'api_documentation.campaigns.breadcrumb' => 'Campaigns',
    'api_documentation.campaigns.title' => 'Campaigns API Documentation',
    'api_documentation.campaigns.header' => 'Campaigns',
    'api_documentation.campaigns.read_all_header' => 'Retrieve campaigns',
    'api_documentation.campaigns.read_header' => 'Retrieve a campaign',

    'api_documentation.notifications.breadcrumb' => 'Notifications',
    'api_documentation.notifications.title' => 'Notifications API Documentation',
    'api_documentation.notifications.header' => 'Notifications',
    'api_documentation.notifications.read_all_header' => 'Retrieve notifications',
    'api_documentation.notifications.read_header' => 'Retrieve a notification',

    'api_documentation.payments.breadcrumb' => 'Payments',
    'api_documentation.payments.title' => 'Payments API Documentation',
    'api_documentation.payments.header' => 'Payments',
    'api_documentation.payments.read_all_header' => 'Retrieve payments',
    'api_documentation.payments.read_header' => 'Retrieve a payment',

    'api_documentation.users_logs.breadcrumb' => 'Logs',
    'api_documentation.users_logs.title' => 'Logs API Documentation',
    'api_documentation.users_logs.header' => 'Logs',
    'api_documentation.users_logs.read_all_header' => 'Retrieve logs',

    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us via email.',

    'contact.input.email' => 'Email address',
    'contact.input.name' => 'Full name',
    'contact.input.subject' => 'Subject',
    'contact.input.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',

    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => '%s commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',

    'notfound.title' => 'Not found',
    'notfound.header' => '404 Not Found',
    'notfound.subheader' => 'The page you’re looking for was not found.',
];
